#include <stdio.h>
#include <string.h>

#define MAXN 200005

int a[MAXN];
int freq[MAXN];    // total count of each value
int countInHand[MAXN];
int N, Q;

int max(int a, int b) {
    return a > b ? a : b;
}

int main() {
    scanf("%d %d", &N, &Q);
    for(int i = 1; i <= N; i++) {
        scanf("%d", &a[i]);
        freq[a[i]]++;
    }

    for(int q = 0; q < Q; q++) {
        int type;
        scanf("%d", &type);
        if(type == 1) {
            int x;
            scanf("%d", &x);

            memset(countInHand, 0, sizeof(countInHand));

            for(int i = 1; i <= x; i++) {
                countInHand[a[i]]++;
            }

            long long sum = 0;
            for(int v = 1; v <= N; v++) {
                int left = countInHand[v] - (freq[v] - countInHand[v]);
                if(left > 0) sum += (long long)left * v;
            }
            printf("%lld\n", sum);
        } else if(type == 2) {
            int pos, y;
            scanf("%d %d", &pos, &y);
            freq[a[pos]]--;
            a[pos] = y;
            freq[y]++;
        }
    }

    return 0;
}